# TeamSpeak Remote Applications API
The client optionally allows applications to establish a connection and receive
information about events, and provide support for custom hotkeys to trigger
events in the client that can be bound to a hotkey.  
Remote applications must be allowed by the user manually the first time they
establish a connection. As long as the user did not revoke the authorization,
future connections do not require the user to allow the application.

> Note: This is currently alpha state and subject to change.  
> This also applies to this documentation, which is probably not as thorough as
> you might want.  
> Please report issues and shortcomings of this documentation
> on the usual channels.

## Connecting
Remote applications work over a websocket connection, which by default is active
on port 5899. Please note that the user can change the port and / or disable
remote applications altogether.

### First connection
After establishing a connection you need to send the following payload:
```json
{
    "type": "auth",
    "payload": {
        "identifier": "net.example.myapp",
        "version": "1.0.0",
        "name": "Example Application",
        "description": "An example application that does things",
        "content": {
            "apiKey": ""
        }
    }
}
```
The identifier needs to be unique, all lower case and should follow standard
naming conventions, as shown in the example above. Only letters a-z and the dot
are valid in the identifier.

#### Response
Once the user authorized the application, you will receive a response that looks
as follows:
```json
{
    "type": "auth",
    "payload": {
        "apiKey": "aef57c76-123a-acdc-5325-e33fe5c4fa27",
        ...
    },
    "status": {
        "code": 0,
        "message": "ok"
    }
}
```
You are expected to store the returned API key in persistent storage and use
this API key for future connections.  
You will also receive additional information about connected servers, clients
and channels on those servers within the payload.  
This will provide you with a complete picture of what the server(s) the client
is connected to looks like. This information is updated through [events](#events)
as they occur.

### Subsequent connections
For subsequent connections, you send the same payload as for the first connection.
However, instead of leaving the apiKey field empty, you fill in the key you last
received as a response to the auth request.

## Hotkey support
Remote applications can send key presses to the TeamSpeak client, which can be used
as regular hotkeys within the client. The procedure to assign a hotkey is the same
as with your regular keyboard.

This allows adding support for arbitrary hardware that is not natively supported
by the client.

Once in Settings -> Key Bindings, select an action to bind to your remote application
key press, start the hotkey assignment and then have the remote application send the
key press.

> Important: The client window **must not** lose focus, otherwise the hotkey
> recording will be stopped.

### Sending a key press
To trigger a key press simply send the following payload:
```json
{
    "type": "keyPress",
    "payload": {
        "button": "some.button",
        "state": true
    }
}
```
The `state` determines whether the event you are sending is an up or down event.
If state is `true` it is a key down event, if it is `false` it is a key up event.

> Note: A hotkey is only recorded by the client if all the keys that you pressed
> are also released again.  
> Basically you want to send one event with state=true and then state=false for
> the exact same button.

The `button` is an arbitrary string you choose to identify your buttons. It needs
to be unique within your applications.

## Events
Remote applications will be notified of events as they happen in the client.  
This includes people switching channels, people talking etc.  
Along with the information received after the initial auth reply, this will
allow you to have an up to date, clear picture of what the client is seeing.

These events generally follow the following format, with the payload varying
depending on the event in question.
```json
{
    "type": "someEvent",
    "payload": {
        ...
    }
}
```
